import matplotlib.pyplot as plt
import matplotlib.patches as patches

# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Define colors for ingredients and statuses
ingredient1_color = 'red'
ingredient2_color = 'blue'
empty_clean_color = 'lightgray'

# Draw shots
shot_positions = [(-3, 0), (0, 0), (3, 0)]
for i, (x, y) in enumerate(shot_positions, start=1):
    ax.add_patch(patches.Rectangle((x, y), 1, 1, edgecolor='black', facecolor=empty_clean_color))
    ax.text(x + 0.5, y + 0.5, f'shot_{i}\nclean\nempty', ha='center', va='center', fontsize=8, color='black')

# Draw shaker
ax.add_patch(patches.Circle((0, -2), 1, edgecolor='black', facecolor=empty_clean_color))
ax.text(0, -2, 'shaker_1\nclean\nempty', ha='center', va='center', fontsize=8, color='black')

# Draw dispensers
ax.add_patch(patches.Rectangle((-3, 2), 1, 1, edgecolor='black', facecolor=ingredient1_color))
ax.text(-3.5, 2.5, 'dispenser_1\ningredient1', ha='right', va='center', fontsize=8, color='white')

ax.add_patch(patches.Rectangle((3, 2), 1, 1, edgecolor='black', facecolor=ingredient2_color))
ax.text(3.5, 2.5, 'dispenser_2\ningredient2', ha='left', va='center', fontsize=8, color='white')

# Draw hands
ax.add_patch(patches.Rectangle((-6, -3), 1, 1, edgecolor='black', facecolor='white'))
ax.text(-5.5, -2.5, 'left_hand\nempty', ha='center', va='center', fontsize=8, color='black')

ax.add_patch(patches.Rectangle((5, -3), 1, 1, edgecolor='black', facecolor='white'))
ax.text(5.5, -2.5, 'right_hand\nempty', ha='center', va='center', fontsize=8, color='black')

# Legend
legend_elements = [
    patches.Patch(facecolor=ingredient1_color, edgecolor='black', label='Ingredient1'),
    patches.Patch(facecolor=ingredient2_color, edgecolor='black', label='Ingredient2'),
    patches.Patch(facecolor=empty_clean_color, edgecolor='black', label='Empty/Clean')
]
ax.legend(handles=legend_elements, loc='upper left', bbox_to_anchor=(1, 1), fontsize=8)

# Set limits and remove axes
ax.set_xlim(-7, 7)
ax.set_ylim(-4, 4)
ax.axis('off')

# Save the diagram
plt.savefig('barman/one_shot/ini_diagram_code/attempts/attempt_29.png', bbox_inches='tight')
plt.show()